mwaextraadmin3ImageResizer.IMAGE_ID_BASE = 'mwaextraadmin3_imageresizer_container_';
mwaextraadmin3ImageResizer.WARNING_ID_BASE = 'mwaextraadmin3_imageresizer_warning_';
mwaextraadmin3ImageResizer.scheduledResizes = [];

function mwaextraadmin3ImageResizer(id, img) {
	this.id = id;
	this.img = img;
	this.originalWidth = 0;
	this.originalHeight = 0;
	this.warning = null;
	this.warningTextNode = null;
	this.originalWidth = img.originalWidth;
	this.originalHeight = img.originalHeight;
	
	img.id = mwaextraadmin3ImageResizer.IMAGE_ID_BASE+id;
}

mwaextraadmin3ImageResizer.executeOnload = function() {
	var rss = mwaextraadmin3ImageResizer.scheduledResizes;
	for(var i = 0; i  < rss.length; i++) {
		mwaextraadmin3ImageResizer.createOn(rss[i], true);
	}
}

mwaextraadmin3ImageResizer.schedule = function(img) {
	if(mwaextraadmin3ImageResizer.scheduledResizes.length == 0) {
		if(window.addEventListener) {
			window.addEventListener('load', mwaextraadmin3ImageResizer.executeOnload, false);
		} else if(window.attachEvent) {
			window.attachEvent('onload', mwaextraadmin3ImageResizer.executeOnload);
		}
	}
	mwaextraadmin3ImageResizer.scheduledResizes.push(img);
}

mwaextraadmin3ImageResizer.getNextId = function() {
	var id = 1;
	while(document.getElementById(mwaextraadmin3ImageResizer.IMAGE_ID_BASE+id) != null) {
		id++;
	}
	return id;
}

mwaextraadmin3ImageResizer.createOnId = function(id) {
	return mwaextraadmin3ImageResizer.createOn(document.getElementById(id));
}

mwaextraadmin3ImageResizer.createOn = function(img, isSchedule) {
	if(typeof isSchedule == 'undefined') isSchedule = false;
	
	if(!img || !img.tagName || img.tagName.toLowerCase() != 'img') {
		alert(img+' is not an image ('+img.tagName.toLowerCase()+')');
	}
	
	if(img.width == 0 || img.height == 0) {
		if(!isSchedule)
			mwaextraadmin3ImageResizer.schedule(img);
		return;
	}
	
	if(!img.originalWidth) img.originalWidth = img.width;
	if(!img.originalHeight) img.originalHeight = img.height;
	
	if((mwaextraadmin3ImageResizer.MAXWIDTH > 0 && img.originalWidth > mwaextraadmin3ImageResizer.MAXWIDTH) || (mwaextraadmin3ImageResizer.MAXHEIGHT > 0 && img.originalHeight > mwaextraadmin3ImageResizer.MAXHEIGHT)) {
		var isRecovery = false; // if this is a recovery from QuickEdit, which only restores the HTML, not the OO structure
		var newid, resizer;
		if(img.id && img.id.indexOf(mwaextraadmin3ImageResizer.IMAGE_ID_BASE) == 0) {
			newid = img.id.substr(mwaextraadmin3ImageResizer.IMAGE_ID_BASE.length);
			if(document.getElementById(mwaextraadmin3ImageResizer.WARNING_ID_BASE+newid) != null) {
				resizer = new mwaextraadmin3ImageResizer(newid, img);
				isRecovery = true;
				resizer.restoreImage();
			}
		} else {
			newid = mwaextraadmin3ImageResizer.getNextId();
			resizer = new mwaextraadmin3ImageResizer(newid, img);
		}
		
		if(isRecovery) {
			resizer.reclaimWarning(newid);
		} else {
			resizer.createWarning();
		}
		resizer.scale();
	}
}

mwaextraadmin3ImageResizer.prototype.restoreImage = function() {
	newimg = document.createElement('IMG');
	newimg.src = this.img.src;
	this.img.width = newimg.width;
	this.img.height = newimg.height;
}

mwaextraadmin3ImageResizer.prototype.reclaimWarning = function(id) {
	this.warning = document.getElementById(mwaextraadmin3ImageResizer.WARNING_ID_BASE+id);
	this.warningTextNode = this.warning.firstChild.firstChild.childNodes[1].firstChild;
	this.warning.resize = this;
	
	this.scale();
}

mwaextraadmin3ImageResizer.prototype.createWarning = function() {
	var mtable = document.createElement('TABLE');
	var mtbody = document.createElement('TBODY');
	var mtr = document.createElement('TR');
	var mtd1 = document.createElement('TD');
	var mtd2 = document.createElement('TD');
	var mimg = document.createElement('IMG');
	var mtext = document.createTextNode('');
	
	mimg.src = mwaextraadmin3ImageResizer.BBURL+'/images/statusicon/wol_error.gif';
	mimg.width = 16;
	mimg.height = 16;
	mimg.alt = '';
	mimg.border = 0;
	
	mtd1.width = 20;
	mtd1.className = 'td1';
	
	mtd2.unselectable = 'on';
	mtd2.className = 'td2';
	
	mtable.className = 'mwaextraadmin3_imageresizer_warning';
	mtable.textNode = mtext;
	mtable.resize = this;
	mtable.id = mwaextraadmin3ImageResizer.WARNING_ID_BASE+this.id;
	
	mtd1.appendChild(mimg);
	mtd2.appendChild(mtext);
	
	mtr.appendChild(mtd1);
	mtr.appendChild(mtd2);
	
	mtbody.appendChild(mtr);
	
	mtable.appendChild(mtbody);
	
	this.img.parentNode.insertBefore(mtable, this.img);
	
	this.warning = mtable;
	this.warningTextNode = mtext;
}

mwaextraadmin3ImageResizer.prototype.setText = function(text) {
	var newnode = document.createTextNode(text);
	this.warningTextNode.parentNode.replaceChild(newnode, this.warningTextNode);
	this.warningTextNode = newnode;
}

mwaextraadmin3ImageResizer.prototype.scale = function() {
	this.img.height = this.originalHeight;
	this.img.width = this.originalWidth;
	
	if(mwaextraadmin3ImageResizer.MAXWIDTH > 0 && this.img.width > mwaextraadmin3ImageResizer.MAXWIDTH) {
		this.img.height = (mwaextraadmin3ImageResizer.MAXWIDTH / this.img.width) * this.img.height;
		this.img.width = mwaextraadmin3ImageResizer.MAXWIDTH;
	}
	
	if(mwaextraadmin3ImageResizer.MAXHEIGHT > 0 && this.img.height > mwaextraadmin3ImageResizer.MAXHEIGHT) {
		this.img.width = (mwaextraadmin3ImageResizer.MAXHEIGHT / this.img.height) * this.img.width;
		this.img.height = mwaextraadmin3ImageResizer.MAXHEIGHT;
	}
	
	this.warning.width = this.img.width;
	this.warning.onclick = function() { return this.resize.unScale(); }
	
	if(this.img.width < 450) {
		this.setText(vbphrase['mwaextraadmin3_imageresizer_warning_small']);
	} else if(this.img.fileSize && this.img.fileSize > 0) {
		this.setText(vbphrase['mwaextraadmin3_imageresizer_warning_filesize'].replace('%1$s', this.originalWidth).replace('%2$s', this.originalHeight).replace('%3$s', Math.round(this.img.fileSize/1024)));
	} else {
		this.setText(vbphrase['mwaextraadmin3_imageresizer_warning_no_filesize'].replace('%1$s', this.originalWidth).replace('%2$s', this.originalHeight));
	}
	
	return false;
}

mwaextraadmin3ImageResizer.prototype.unScale = function() {
	switch(mwaextraadmin3ImageResizer.MODE) {
		case 'samewindow':
			window.open(this.img.src, '_self');
			break;
		case 'newwindow':
			window.open(this.img.src, '_blank');
			break;
		case 'enlarge':
		default:
			this.img.width = this.originalWidth;
			this.img.height = this.originalHeight;
			this.img.className = 'mwaextraadmin3_imageresizer_original';
			if(this.warning != null) {
				this.setText(vbphrase['mwaextraadmin3_imageresizer_warning_fullsize']);
				this.warning.width = this.img.width;
				this.warning.onclick = function() { return this.resize.scale() };
			}
			break;
	}
	
	return false;
}